#ifndef DEQUE_H_
#define DEQUE_H_

template<typename T>
struct elem
{
	T inf;
	elem * neighbours[2];
};

template<class T>
class Deque
{
public:
	Deque();
	Deque(const Deque &);
	~Deque();
	Deque& operator=(const Deque&);

	void pushBack(const T & value);
	void pushFront(const T & value);

	void popBack();
	void popFront();

	T back() const;
	T front() const;

	bool isEmpty() const;

//	friend ostream& operator<<(ostream&, const Deque&);
//	friend istream& operator>>(istream&, Deque&);
private:
	void pop(int);
	void push(const T &, int);
	T element(int) const;
	elem<T> * link[2];
};

#endif